string GetDescription()
{
	return "Renders the harmony into a simple melody with sine like velocity and random rythm.";
}

int first_pitch = 0;
int last_pitch = 0;

void SetFirstPitch(int f)
{
	first_pitch = f;
	last_pitch = f;	
}	

int GetNextPitch(int p)
{
	int cur_pitch = p;
	if (cur_pitch - 7 > last_pitch) cur_pitch -= 12;
	last_pitch = cur_pitch;
	return cur_pitch;
}

double phase;
double period;
double vel_from;
double vel_to;

int GetVel(double al)
{
	return vel_from + ((sin(al*period + phase)+1.0) / 2.0) * (vel_to-vel_from);
}

void Render(RenderPart @p)
{
	int tempo = p.GetTempo() + RndInt(-50,50);
	
	phase = RndFloat(-1,1);
	period = RndFloat(p.GetUniquePart().GetMetrum()/8.0,p.GetUniquePart().GetMetrum());
	
	vel_from = RndInt(30,50);
	vel_to = RndInt(110,120);
	
	double delta = 0.5;
	if (tempo > 150) delta = 1.0;
	if (tempo < 60) delta = 0.25;
	
	Time t = CreateTime(p.GetStartBar(), 0);

	int[] pattern(RndInt(3,8));
	
	for (uint i = 0; i < pattern.length(); i++)
	{
		pattern[i] = RndInt(-1,1);
		if (RndInt(0,4) == 0) pattern[i] = -2;
	}
	
	int n = 0;

	SetFirstPitch(p.GetHarmonicEventPitch(0, 0));
		
	double al = 0;
	
	while (t.m_Bar < p.GetEndBar())
	{
		int harm = p.GetHarmonic(t);
		int pit = GetNextPitch(p.GetHarmonicEventPitch(harm, 0)); 
			
		if (pattern[n % pattern.length()] == 0)	p.AddNote(t, CreateTime(t.m_Bar, t.m_Pos + delta/2.0), pit, GetVel(al));
		if (pattern[n % pattern.length()] == 1)	p.AddNote(t, CreateTime(t.m_Bar, t.m_Pos + delta/2.0), p.AlignPitch(pit,7), GetVel(al));
		if (pattern[n % pattern.length()] == -1) p.AddNote(t, CreateTime(t.m_Bar, t.m_Pos + delta/2.0), p.AlignPitch(pit,-7), GetVel(al));
		
		t.m_Pos += delta;
		al += delta;
		if (t.m_Pos >= p.GetUniquePart().GetMetrum())
		{
			t.m_Pos = 0;		
			t.m_Bar++;
		}
		n++;
	}
}
